package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{RoutingProfileId, ARN}
import scala.jdk.CollectionConverters._
final case class CreateRoutingProfileResponse(
    routingProfileArn: Option[ARN] = None,
    routingProfileId: Option[RoutingProfileId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateRoutingProfileResponse = {
    import CreateRoutingProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateRoutingProfileResponse
      .builder()
      .optionallyWith(
        routingProfileArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.routingProfileArn)
      .optionallyWith(
        routingProfileId.map(value =>
          RoutingProfileId.unwrap(value): java.lang.String
        )
      )(_.routingProfileId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateRoutingProfileResponse.ReadOnly =
    zio.aws.connect.model.CreateRoutingProfileResponse.wrap(buildAwsValue())
}
object CreateRoutingProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateRoutingProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateRoutingProfileResponse =
      zio.aws.connect.model.CreateRoutingProfileResponse(
        routingProfileArn.map(value => value),
        routingProfileId.map(value => value)
      )
    def routingProfileArn: Option[ARN]
    def routingProfileId: Option[RoutingProfileId]
    def getRoutingProfileArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("routingProfileArn", routingProfileArn)
    def getRoutingProfileId: ZIO[Any, AwsError, RoutingProfileId] =
      AwsError.unwrapOptionField("routingProfileId", routingProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateRoutingProfileResponse
  ) extends zio.aws.connect.model.CreateRoutingProfileResponse.ReadOnly {
    override val routingProfileArn: Option[ARN] = scala
      .Option(impl.routingProfileArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val routingProfileId: Option[RoutingProfileId] = scala
      .Option(impl.routingProfileId())
      .map(value => zio.aws.connect.model.primitives.RoutingProfileId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateRoutingProfileResponse
  ): zio.aws.connect.model.CreateRoutingProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
