package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{ARN, UseCaseId}
import scala.jdk.CollectionConverters._
final case class CreateUseCaseResponse(
    useCaseId: Option[UseCaseId] = None,
    useCaseArn: Option[ARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateUseCaseResponse = {
    import CreateUseCaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateUseCaseResponse
      .builder()
      .optionallyWith(
        useCaseId.map(value => UseCaseId.unwrap(value): java.lang.String)
      )(_.useCaseId)
      .optionallyWith(
        useCaseArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.useCaseArn)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateUseCaseResponse.ReadOnly =
    zio.aws.connect.model.CreateUseCaseResponse.wrap(buildAwsValue())
}
object CreateUseCaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateUseCaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateUseCaseResponse =
      zio.aws.connect.model.CreateUseCaseResponse(
        useCaseId.map(value => value),
        useCaseArn.map(value => value)
      )
    def useCaseId: Option[UseCaseId]
    def useCaseArn: Option[ARN]
    def getUseCaseId: ZIO[Any, AwsError, UseCaseId] =
      AwsError.unwrapOptionField("useCaseId", useCaseId)
    def getUseCaseArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("useCaseArn", useCaseArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateUseCaseResponse
  ) extends zio.aws.connect.model.CreateUseCaseResponse.ReadOnly {
    override val useCaseId: Option[UseCaseId] = scala
      .Option(impl.useCaseId())
      .map(value => zio.aws.connect.model.primitives.UseCaseId(value))
    override val useCaseArn: Option[ARN] = scala
      .Option(impl.useCaseArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateUseCaseResponse
  ): zio.aws.connect.model.CreateUseCaseResponse.ReadOnly = new Wrapper(impl)
}
