package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  InstanceId,
  HierarchyGroupId,
  HierarchyGroupName
}
import scala.jdk.CollectionConverters._
final case class CreateUserHierarchyGroupRequest(
    name: HierarchyGroupName,
    parentGroupId: Option[HierarchyGroupId] = None,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest = {
    import CreateUserHierarchyGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest
      .builder()
      .name(HierarchyGroupName.unwrap(name): java.lang.String)
      .optionallyWith(
        parentGroupId.map(value =>
          HierarchyGroupId.unwrap(value): java.lang.String
        )
      )(_.parentGroupId)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.CreateUserHierarchyGroupRequest.ReadOnly =
    zio.aws.connect.model.CreateUserHierarchyGroupRequest.wrap(buildAwsValue())
}
object CreateUserHierarchyGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateUserHierarchyGroupRequest =
      zio.aws.connect.model.CreateUserHierarchyGroupRequest(
        name,
        parentGroupId.map(value => value),
        instanceId
      )
    def name: HierarchyGroupName
    def parentGroupId: Option[HierarchyGroupId]
    def instanceId: InstanceId
    def getName: ZIO[Any, Nothing, HierarchyGroupName] = ZIO.succeed(name)
    def getParentGroupId: ZIO[Any, AwsError, HierarchyGroupId] =
      AwsError.unwrapOptionField("parentGroupId", parentGroupId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest
  ) extends zio.aws.connect.model.CreateUserHierarchyGroupRequest.ReadOnly {
    override val name: HierarchyGroupName =
      zio.aws.connect.model.primitives.HierarchyGroupName(impl.name())
    override val parentGroupId: Option[HierarchyGroupId] = scala
      .Option(impl.parentGroupId())
      .map(value => zio.aws.connect.model.primitives.HierarchyGroupId(value))
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest
  ): zio.aws.connect.model.CreateUserHierarchyGroupRequest.ReadOnly =
    new Wrapper(impl)
}
