package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.connect.model.primitives.{Timestamp, SecurityToken}
import scala.jdk.CollectionConverters._
final case class Credentials(
    accessToken: Option[SecurityToken] = None,
    accessTokenExpiration: Option[Timestamp] = None,
    refreshToken: Option[SecurityToken] = None,
    refreshTokenExpiration: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.Credentials = {
    import Credentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Credentials
      .builder()
      .optionallyWith(
        accessToken.map(value => SecurityToken.unwrap(value): java.lang.String)
      )(_.accessToken)
      .optionallyWith(
        accessTokenExpiration.map(value => Timestamp.unwrap(value): Instant)
      )(_.accessTokenExpiration)
      .optionallyWith(
        refreshToken.map(value => SecurityToken.unwrap(value): java.lang.String)
      )(_.refreshToken)
      .optionallyWith(
        refreshTokenExpiration.map(value => Timestamp.unwrap(value): Instant)
      )(_.refreshTokenExpiration)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Credentials.ReadOnly =
    zio.aws.connect.model.Credentials.wrap(buildAwsValue())
}
object Credentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.Credentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Credentials =
      zio.aws.connect.model.Credentials(
        accessToken.map(value => value),
        accessTokenExpiration.map(value => value),
        refreshToken.map(value => value),
        refreshTokenExpiration.map(value => value)
      )
    def accessToken: Option[SecurityToken]
    def accessTokenExpiration: Option[Timestamp]
    def refreshToken: Option[SecurityToken]
    def refreshTokenExpiration: Option[Timestamp]
    def getAccessToken: ZIO[Any, AwsError, SecurityToken] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getAccessTokenExpiration: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("accessTokenExpiration", accessTokenExpiration)
    def getRefreshToken: ZIO[Any, AwsError, SecurityToken] =
      AwsError.unwrapOptionField("refreshToken", refreshToken)
    def getRefreshTokenExpiration: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("refreshTokenExpiration", refreshTokenExpiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Credentials
  ) extends zio.aws.connect.model.Credentials.ReadOnly {
    override val accessToken: Option[SecurityToken] = scala
      .Option(impl.accessToken())
      .map(value => zio.aws.connect.model.primitives.SecurityToken(value))
    override val accessTokenExpiration: Option[Timestamp] = scala
      .Option(impl.accessTokenExpiration())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val refreshToken: Option[SecurityToken] = scala
      .Option(impl.refreshToken())
      .map(value => zio.aws.connect.model.primitives.SecurityToken(value))
    override val refreshTokenExpiration: Option[Timestamp] = scala
      .Option(impl.refreshTokenExpiration())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Credentials
  ): zio.aws.connect.model.Credentials.ReadOnly = new Wrapper(impl)
}
