package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CurrentMetric(
    name: Option[zio.aws.connect.model.CurrentMetricName] = None,
    unit: Option[zio.aws.connect.model.Unit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CurrentMetric = {
    import CurrentMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CurrentMetric
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CurrentMetric.ReadOnly =
    zio.aws.connect.model.CurrentMetric.wrap(buildAwsValue())
}
object CurrentMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CurrentMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CurrentMetric = zio.aws.connect.model
      .CurrentMetric(name.map(value => value), unit.map(value => value))
    def name: Option[zio.aws.connect.model.CurrentMetricName]
    def unit: Option[zio.aws.connect.model.Unit]
    def getName: ZIO[Any, AwsError, zio.aws.connect.model.CurrentMetricName] =
      AwsError.unwrapOptionField("name", name)
    def getUnit: ZIO[Any, AwsError, zio.aws.connect.model.Unit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CurrentMetric
  ) extends zio.aws.connect.model.CurrentMetric.ReadOnly {
    override val name: Option[zio.aws.connect.model.CurrentMetricName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.CurrentMetricName.wrap(value))
    override val unit: Option[zio.aws.connect.model.Unit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.connect.model.Unit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CurrentMetric
  ): zio.aws.connect.model.CurrentMetric.ReadOnly = new Wrapper(impl)
}
