package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.Value
import scala.jdk.CollectionConverters._
final case class CurrentMetricData(
    metric: Option[zio.aws.connect.model.CurrentMetric] = None,
    value: Option[Value] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CurrentMetricData = {
    import CurrentMetricData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CurrentMetricData
      .builder()
      .optionallyWith(metric.map(value => value.buildAwsValue()))(_.metric)
      .optionallyWith(
        value.map(value => Value.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CurrentMetricData.ReadOnly =
    zio.aws.connect.model.CurrentMetricData.wrap(buildAwsValue())
}
object CurrentMetricData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CurrentMetricData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CurrentMetricData =
      zio.aws.connect.model.CurrentMetricData(
        metric.map(value => value.asEditable),
        value.map(value => value)
      )
    def metric: Option[zio.aws.connect.model.CurrentMetric.ReadOnly]
    def value: Option[Value]
    def getMetric
        : ZIO[Any, AwsError, zio.aws.connect.model.CurrentMetric.ReadOnly] =
      AwsError.unwrapOptionField("metric", metric)
    def getValue: ZIO[Any, AwsError, Value] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CurrentMetricData
  ) extends zio.aws.connect.model.CurrentMetricData.ReadOnly {
    override val metric: Option[zio.aws.connect.model.CurrentMetric.ReadOnly] =
      scala
        .Option(impl.metric())
        .map(value => zio.aws.connect.model.CurrentMetric.wrap(value))
    override val value: Option[Value] = scala
      .Option(impl.value())
      .map(value => zio.aws.connect.model.primitives.Value(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CurrentMetricData
  ): zio.aws.connect.model.CurrentMetricData.ReadOnly = new Wrapper(impl)
}
