package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait CurrentMetricName {
  def unwrap: software.amazon.awssdk.services.connect.model.CurrentMetricName
}
object CurrentMetricName {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.CurrentMetricName
  ): zio.aws.connect.model.CurrentMetricName = value match {
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_ONLINE =>
      val r = AGENTS_ONLINE
      r
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_AVAILABLE =>
      val r = AGENTS_AVAILABLE
      r
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_ON_CALL =>
      val r = AGENTS_ON_CALL
      r
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_NON_PRODUCTIVE =>
      val r = AGENTS_NON_PRODUCTIVE
      r
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_AFTER_CONTACT_WORK =>
      val r = AGENTS_AFTER_CONTACT_WORK
      r
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_ERROR =>
      val r = AGENTS_ERROR
      r
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_STAFFED =>
      val r = AGENTS_STAFFED
      r
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.CONTACTS_IN_QUEUE =>
      val r = CONTACTS_IN_QUEUE
      r
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.OLDEST_CONTACT_AGE =>
      val r = OLDEST_CONTACT_AGE
      r
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.CONTACTS_SCHEDULED =>
      val r = CONTACTS_SCHEDULED
      r
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_ON_CONTACT =>
      val r = AGENTS_ON_CONTACT
      r
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.SLOTS_ACTIVE =>
      val r = SLOTS_ACTIVE
      r
    case software.amazon.awssdk.services.connect.model.CurrentMetricName.SLOTS_AVAILABLE =>
      val r = SLOTS_AVAILABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.UNKNOWN_TO_SDK_VERSION
  }
  case object AGENTS_ONLINE extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_ONLINE
  }
  case object AGENTS_AVAILABLE extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_AVAILABLE
  }
  case object AGENTS_ON_CALL extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_ON_CALL
  }
  case object AGENTS_NON_PRODUCTIVE
      extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_NON_PRODUCTIVE
  }
  case object AGENTS_AFTER_CONTACT_WORK
      extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_AFTER_CONTACT_WORK
  }
  case object AGENTS_ERROR extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_ERROR
  }
  case object AGENTS_STAFFED extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_STAFFED
  }
  case object CONTACTS_IN_QUEUE
      extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.CONTACTS_IN_QUEUE
  }
  case object OLDEST_CONTACT_AGE
      extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.OLDEST_CONTACT_AGE
  }
  case object CONTACTS_SCHEDULED
      extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.CONTACTS_SCHEDULED
  }
  case object AGENTS_ON_CONTACT
      extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.AGENTS_ON_CONTACT
  }
  case object SLOTS_ACTIVE extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.SLOTS_ACTIVE
  }
  case object SLOTS_AVAILABLE extends zio.aws.connect.model.CurrentMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.CurrentMetricName =
      software.amazon.awssdk.services.connect.model.CurrentMetricName.SLOTS_AVAILABLE
  }
}
