package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{IntegrationAssociationId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DeleteIntegrationAssociationRequest(
    instanceId: InstanceId,
    integrationAssociationId: IntegrationAssociationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationRequest = {
    import DeleteIntegrationAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .integrationAssociationId(
        IntegrationAssociationId.unwrap(
          integrationAssociationId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DeleteIntegrationAssociationRequest.ReadOnly =
    zio.aws.connect.model.DeleteIntegrationAssociationRequest
      .wrap(buildAwsValue())
}
object DeleteIntegrationAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteIntegrationAssociationRequest =
      zio.aws.connect.model.DeleteIntegrationAssociationRequest(
        instanceId,
        integrationAssociationId
      )
    def instanceId: InstanceId
    def integrationAssociationId: IntegrationAssociationId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getIntegrationAssociationId
        : ZIO[Any, Nothing, IntegrationAssociationId] =
      ZIO.succeed(integrationAssociationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationRequest
  ) extends zio.aws.connect.model.DeleteIntegrationAssociationRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val integrationAssociationId: IntegrationAssociationId =
      zio.aws.connect.model.primitives
        .IntegrationAssociationId(impl.integrationAssociationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationRequest
  ): zio.aws.connect.model.DeleteIntegrationAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
