package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{InstanceId, HierarchyGroupId}
import scala.jdk.CollectionConverters._
final case class DeleteUserHierarchyGroupRequest(
    hierarchyGroupId: HierarchyGroupId,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupRequest = {
    import DeleteUserHierarchyGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupRequest
      .builder()
      .hierarchyGroupId(
        HierarchyGroupId.unwrap(hierarchyGroupId): java.lang.String
      )
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DeleteUserHierarchyGroupRequest.ReadOnly =
    zio.aws.connect.model.DeleteUserHierarchyGroupRequest.wrap(buildAwsValue())
}
object DeleteUserHierarchyGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteUserHierarchyGroupRequest =
      zio.aws.connect.model
        .DeleteUserHierarchyGroupRequest(hierarchyGroupId, instanceId)
    def hierarchyGroupId: HierarchyGroupId
    def instanceId: InstanceId
    def getHierarchyGroupId: ZIO[Any, Nothing, HierarchyGroupId] =
      ZIO.succeed(hierarchyGroupId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupRequest
  ) extends zio.aws.connect.model.DeleteUserHierarchyGroupRequest.ReadOnly {
    override val hierarchyGroupId: HierarchyGroupId =
      zio.aws.connect.model.primitives.HierarchyGroupId(impl.hierarchyGroupId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupRequest
  ): zio.aws.connect.model.DeleteUserHierarchyGroupRequest.ReadOnly =
    new Wrapper(impl)
}
