package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{UserId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DeleteUserRequest(instanceId: InstanceId, userId: UserId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteUserRequest = {
    import DeleteUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteUserRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .userId(UserId.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteUserRequest.ReadOnly =
    zio.aws.connect.model.DeleteUserRequest.wrap(buildAwsValue())
}
object DeleteUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteUserRequest =
      zio.aws.connect.model.DeleteUserRequest(instanceId, userId)
    def instanceId: InstanceId
    def userId: UserId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteUserRequest
  ) extends zio.aws.connect.model.DeleteUserRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val userId: UserId =
      zio.aws.connect.model.primitives.UserId(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteUserRequest
  ): zio.aws.connect.model.DeleteUserRequest.ReadOnly = new Wrapper(impl)
}
