package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAgentStatusResponse(
    agentStatus: Option[zio.aws.connect.model.AgentStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeAgentStatusResponse = {
    import DescribeAgentStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeAgentStatusResponse
      .builder()
      .optionallyWith(agentStatus.map(value => value.buildAwsValue()))(
        _.agentStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeAgentStatusResponse.ReadOnly =
    zio.aws.connect.model.DescribeAgentStatusResponse.wrap(buildAwsValue())
}
object DescribeAgentStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeAgentStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeAgentStatusResponse =
      zio.aws.connect.model
        .DescribeAgentStatusResponse(agentStatus.map(value => value.asEditable))
    def agentStatus: Option[zio.aws.connect.model.AgentStatus.ReadOnly]
    def getAgentStatus
        : ZIO[Any, AwsError, zio.aws.connect.model.AgentStatus.ReadOnly] =
      AwsError.unwrapOptionField("agentStatus", agentStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeAgentStatusResponse
  ) extends zio.aws.connect.model.DescribeAgentStatusResponse.ReadOnly {
    override val agentStatus
        : Option[zio.aws.connect.model.AgentStatus.ReadOnly] = scala
      .Option(impl.agentStatus())
      .map(value => zio.aws.connect.model.AgentStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeAgentStatusResponse
  ): zio.aws.connect.model.DescribeAgentStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
