package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeContactFlowModuleResponse(
    contactFlowModule: Option[zio.aws.connect.model.ContactFlowModule] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleResponse = {
    import DescribeContactFlowModuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleResponse
      .builder()
      .optionallyWith(contactFlowModule.map(value => value.buildAwsValue()))(
        _.contactFlowModule
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeContactFlowModuleResponse.ReadOnly =
    zio.aws.connect.model.DescribeContactFlowModuleResponse
      .wrap(buildAwsValue())
}
object DescribeContactFlowModuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeContactFlowModuleResponse =
      zio.aws.connect.model.DescribeContactFlowModuleResponse(
        contactFlowModule.map(value => value.asEditable)
      )
    def contactFlowModule
        : Option[zio.aws.connect.model.ContactFlowModule.ReadOnly]
    def getContactFlowModule
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowModule.ReadOnly] =
      AwsError.unwrapOptionField("contactFlowModule", contactFlowModule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleResponse
  ) extends zio.aws.connect.model.DescribeContactFlowModuleResponse.ReadOnly {
    override val contactFlowModule
        : Option[zio.aws.connect.model.ContactFlowModule.ReadOnly] = scala
      .Option(impl.contactFlowModule())
      .map(value => zio.aws.connect.model.ContactFlowModule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleResponse
  ): zio.aws.connect.model.DescribeContactFlowModuleResponse.ReadOnly =
    new Wrapper(impl)
}
