package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ContactFlowId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DescribeContactFlowRequest(
    instanceId: InstanceId,
    contactFlowId: ContactFlowId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeContactFlowRequest = {
    import DescribeContactFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeContactFlowRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactFlowId(ContactFlowId.unwrap(contactFlowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeContactFlowRequest.ReadOnly =
    zio.aws.connect.model.DescribeContactFlowRequest.wrap(buildAwsValue())
}
object DescribeContactFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeContactFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeContactFlowRequest =
      zio.aws.connect.model
        .DescribeContactFlowRequest(instanceId, contactFlowId)
    def instanceId: InstanceId
    def contactFlowId: ContactFlowId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactFlowId: ZIO[Any, Nothing, ContactFlowId] =
      ZIO.succeed(contactFlowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactFlowRequest
  ) extends zio.aws.connect.model.DescribeContactFlowRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactFlowId: ContactFlowId =
      zio.aws.connect.model.primitives.ContactFlowId(impl.contactFlowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactFlowRequest
  ): zio.aws.connect.model.DescribeContactFlowRequest.ReadOnly = new Wrapper(
    impl
  )
}
