package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ContactId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DescribeContactRequest(
    instanceId: InstanceId,
    contactId: ContactId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeContactRequest = {
    import DescribeContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeContactRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeContactRequest.ReadOnly =
    zio.aws.connect.model.DescribeContactRequest.wrap(buildAwsValue())
}
object DescribeContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeContactRequest =
      zio.aws.connect.model.DescribeContactRequest(instanceId, contactId)
    def instanceId: InstanceId
    def contactId: ContactId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactRequest
  ) extends zio.aws.connect.model.DescribeContactRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactRequest
  ): zio.aws.connect.model.DescribeContactRequest.ReadOnly = new Wrapper(impl)
}
