package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeContactResponse(
    contact: Option[zio.aws.connect.model.Contact] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeContactResponse = {
    import DescribeContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeContactResponse
      .builder()
      .optionallyWith(contact.map(value => value.buildAwsValue()))(_.contact)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeContactResponse.ReadOnly =
    zio.aws.connect.model.DescribeContactResponse.wrap(buildAwsValue())
}
object DescribeContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeContactResponse =
      zio.aws.connect.model
        .DescribeContactResponse(contact.map(value => value.asEditable))
    def contact: Option[zio.aws.connect.model.Contact.ReadOnly]
    def getContact: ZIO[Any, AwsError, zio.aws.connect.model.Contact.ReadOnly] =
      AwsError.unwrapOptionField("contact", contact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactResponse
  ) extends zio.aws.connect.model.DescribeContactResponse.ReadOnly {
    override val contact: Option[zio.aws.connect.model.Contact.ReadOnly] = scala
      .Option(impl.contact())
      .map(value => zio.aws.connect.model.Contact.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactResponse
  ): zio.aws.connect.model.DescribeContactResponse.ReadOnly = new Wrapper(impl)
}
