package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.InstanceId
import scala.jdk.CollectionConverters._
final case class DescribeInstanceAttributeRequest(
    instanceId: InstanceId,
    attributeType: zio.aws.connect.model.InstanceAttributeType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeRequest = {
    import DescribeInstanceAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .attributeType(attributeType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeInstanceAttributeRequest.ReadOnly =
    zio.aws.connect.model.DescribeInstanceAttributeRequest.wrap(buildAwsValue())
}
object DescribeInstanceAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeInstanceAttributeRequest =
      zio.aws.connect.model
        .DescribeInstanceAttributeRequest(instanceId, attributeType)
    def instanceId: InstanceId
    def attributeType: zio.aws.connect.model.InstanceAttributeType
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getAttributeType
        : ZIO[Any, Nothing, zio.aws.connect.model.InstanceAttributeType] =
      ZIO.succeed(attributeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeRequest
  ) extends zio.aws.connect.model.DescribeInstanceAttributeRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val attributeType: zio.aws.connect.model.InstanceAttributeType =
      zio.aws.connect.model.InstanceAttributeType.wrap(impl.attributeType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeRequest
  ): zio.aws.connect.model.DescribeInstanceAttributeRequest.ReadOnly =
    new Wrapper(impl)
}
