package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.InstanceId
import scala.jdk.CollectionConverters._
final case class DescribeInstanceRequest(instanceId: InstanceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeInstanceRequest = {
    import DescribeInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeInstanceRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeInstanceRequest.ReadOnly =
    zio.aws.connect.model.DescribeInstanceRequest.wrap(buildAwsValue())
}
object DescribeInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeInstanceRequest =
      zio.aws.connect.model.DescribeInstanceRequest(instanceId)
    def instanceId: InstanceId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeInstanceRequest
  ) extends zio.aws.connect.model.DescribeInstanceRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeInstanceRequest
  ): zio.aws.connect.model.DescribeInstanceRequest.ReadOnly = new Wrapper(impl)
}
