package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeQueueResponse(
    queue: Option[zio.aws.connect.model.Queue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeQueueResponse = {
    import DescribeQueueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeQueueResponse
      .builder()
      .optionallyWith(queue.map(value => value.buildAwsValue()))(_.queue)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeQueueResponse.ReadOnly =
    zio.aws.connect.model.DescribeQueueResponse.wrap(buildAwsValue())
}
object DescribeQueueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeQueueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeQueueResponse =
      zio.aws.connect.model
        .DescribeQueueResponse(queue.map(value => value.asEditable))
    def queue: Option[zio.aws.connect.model.Queue.ReadOnly]
    def getQueue: ZIO[Any, AwsError, zio.aws.connect.model.Queue.ReadOnly] =
      AwsError.unwrapOptionField("queue", queue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeQueueResponse
  ) extends zio.aws.connect.model.DescribeQueueResponse.ReadOnly {
    override val queue: Option[zio.aws.connect.model.Queue.ReadOnly] = scala
      .Option(impl.queue())
      .map(value => zio.aws.connect.model.Queue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeQueueResponse
  ): zio.aws.connect.model.DescribeQueueResponse.ReadOnly = new Wrapper(impl)
}
