package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeQuickConnectResponse(
    quickConnect: Option[zio.aws.connect.model.QuickConnect] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeQuickConnectResponse = {
    import DescribeQuickConnectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeQuickConnectResponse
      .builder()
      .optionallyWith(quickConnect.map(value => value.buildAwsValue()))(
        _.quickConnect
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeQuickConnectResponse.ReadOnly =
    zio.aws.connect.model.DescribeQuickConnectResponse.wrap(buildAwsValue())
}
object DescribeQuickConnectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeQuickConnectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeQuickConnectResponse =
      zio.aws.connect.model.DescribeQuickConnectResponse(
        quickConnect.map(value => value.asEditable)
      )
    def quickConnect: Option[zio.aws.connect.model.QuickConnect.ReadOnly]
    def getQuickConnect
        : ZIO[Any, AwsError, zio.aws.connect.model.QuickConnect.ReadOnly] =
      AwsError.unwrapOptionField("quickConnect", quickConnect)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeQuickConnectResponse
  ) extends zio.aws.connect.model.DescribeQuickConnectResponse.ReadOnly {
    override val quickConnect
        : Option[zio.aws.connect.model.QuickConnect.ReadOnly] = scala
      .Option(impl.quickConnect())
      .map(value => zio.aws.connect.model.QuickConnect.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeQuickConnectResponse
  ): zio.aws.connect.model.DescribeQuickConnectResponse.ReadOnly = new Wrapper(
    impl
  )
}
