package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeRoutingProfileResponse(
    routingProfile: Option[zio.aws.connect.model.RoutingProfile] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeRoutingProfileResponse = {
    import DescribeRoutingProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeRoutingProfileResponse
      .builder()
      .optionallyWith(routingProfile.map(value => value.buildAwsValue()))(
        _.routingProfile
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeRoutingProfileResponse.ReadOnly =
    zio.aws.connect.model.DescribeRoutingProfileResponse.wrap(buildAwsValue())
}
object DescribeRoutingProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeRoutingProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeRoutingProfileResponse =
      zio.aws.connect.model.DescribeRoutingProfileResponse(
        routingProfile.map(value => value.asEditable)
      )
    def routingProfile: Option[zio.aws.connect.model.RoutingProfile.ReadOnly]
    def getRoutingProfile
        : ZIO[Any, AwsError, zio.aws.connect.model.RoutingProfile.ReadOnly] =
      AwsError.unwrapOptionField("routingProfile", routingProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeRoutingProfileResponse
  ) extends zio.aws.connect.model.DescribeRoutingProfileResponse.ReadOnly {
    override val routingProfile
        : Option[zio.aws.connect.model.RoutingProfile.ReadOnly] = scala
      .Option(impl.routingProfile())
      .map(value => zio.aws.connect.model.RoutingProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeRoutingProfileResponse
  ): zio.aws.connect.model.DescribeRoutingProfileResponse.ReadOnly =
    new Wrapper(impl)
}
