package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{InstanceId, SecurityProfileId}
import scala.jdk.CollectionConverters._
final case class DescribeSecurityProfileRequest(
    securityProfileId: SecurityProfileId,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeSecurityProfileRequest = {
    import DescribeSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeSecurityProfileRequest
      .builder()
      .securityProfileId(
        SecurityProfileId.unwrap(securityProfileId): java.lang.String
      )
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeSecurityProfileRequest.ReadOnly =
    zio.aws.connect.model.DescribeSecurityProfileRequest.wrap(buildAwsValue())
}
object DescribeSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeSecurityProfileRequest =
      zio.aws.connect.model
        .DescribeSecurityProfileRequest(securityProfileId, instanceId)
    def securityProfileId: SecurityProfileId
    def instanceId: InstanceId
    def getSecurityProfileId: ZIO[Any, Nothing, SecurityProfileId] =
      ZIO.succeed(securityProfileId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeSecurityProfileRequest
  ) extends zio.aws.connect.model.DescribeSecurityProfileRequest.ReadOnly {
    override val securityProfileId: SecurityProfileId =
      zio.aws.connect.model.primitives
        .SecurityProfileId(impl.securityProfileId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeSecurityProfileRequest
  ): zio.aws.connect.model.DescribeSecurityProfileRequest.ReadOnly =
    new Wrapper(impl)
}
