package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeUserHierarchyGroupResponse(
    hierarchyGroup: Option[zio.aws.connect.model.HierarchyGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupResponse = {
    import DescribeUserHierarchyGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupResponse
      .builder()
      .optionallyWith(hierarchyGroup.map(value => value.buildAwsValue()))(
        _.hierarchyGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeUserHierarchyGroupResponse.ReadOnly =
    zio.aws.connect.model.DescribeUserHierarchyGroupResponse
      .wrap(buildAwsValue())
}
object DescribeUserHierarchyGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeUserHierarchyGroupResponse =
      zio.aws.connect.model.DescribeUserHierarchyGroupResponse(
        hierarchyGroup.map(value => value.asEditable)
      )
    def hierarchyGroup: Option[zio.aws.connect.model.HierarchyGroup.ReadOnly]
    def getHierarchyGroup
        : ZIO[Any, AwsError, zio.aws.connect.model.HierarchyGroup.ReadOnly] =
      AwsError.unwrapOptionField("hierarchyGroup", hierarchyGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupResponse
  ) extends zio.aws.connect.model.DescribeUserHierarchyGroupResponse.ReadOnly {
    override val hierarchyGroup
        : Option[zio.aws.connect.model.HierarchyGroup.ReadOnly] = scala
      .Option(impl.hierarchyGroup())
      .map(value => zio.aws.connect.model.HierarchyGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupResponse
  ): zio.aws.connect.model.DescribeUserHierarchyGroupResponse.ReadOnly =
    new Wrapper(impl)
}
