package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeUserHierarchyStructureResponse(
    hierarchyStructure: Option[zio.aws.connect.model.HierarchyStructure] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureResponse = {
    import DescribeUserHierarchyStructureResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureResponse
      .builder()
      .optionallyWith(hierarchyStructure.map(value => value.buildAwsValue()))(
        _.hierarchyStructure
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeUserHierarchyStructureResponse.ReadOnly =
    zio.aws.connect.model.DescribeUserHierarchyStructureResponse
      .wrap(buildAwsValue())
}
object DescribeUserHierarchyStructureResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.DescribeUserHierarchyStructureResponse =
      zio.aws.connect.model.DescribeUserHierarchyStructureResponse(
        hierarchyStructure.map(value => value.asEditable)
      )
    def hierarchyStructure
        : Option[zio.aws.connect.model.HierarchyStructure.ReadOnly]
    def getHierarchyStructure: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyStructure.ReadOnly
    ] = AwsError.unwrapOptionField("hierarchyStructure", hierarchyStructure)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureResponse
  ) extends zio.aws.connect.model.DescribeUserHierarchyStructureResponse.ReadOnly {
    override val hierarchyStructure
        : Option[zio.aws.connect.model.HierarchyStructure.ReadOnly] = scala
      .Option(impl.hierarchyStructure())
      .map(value => zio.aws.connect.model.HierarchyStructure.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureResponse
  ): zio.aws.connect.model.DescribeUserHierarchyStructureResponse.ReadOnly =
    new Wrapper(impl)
}
