package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeUserResponse(
    user: Option[zio.aws.connect.model.User] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeUserResponse = {
    import DescribeUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeUserResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeUserResponse.ReadOnly =
    zio.aws.connect.model.DescribeUserResponse.wrap(buildAwsValue())
}
object DescribeUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeUserResponse =
      zio.aws.connect.model
        .DescribeUserResponse(user.map(value => value.asEditable))
    def user: Option[zio.aws.connect.model.User.ReadOnly]
    def getUser: ZIO[Any, AwsError, zio.aws.connect.model.User.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeUserResponse
  ) extends zio.aws.connect.model.DescribeUserResponse.ReadOnly {
    override val user: Option[zio.aws.connect.model.User.ReadOnly] = scala
      .Option(impl.user())
      .map(value => zio.aws.connect.model.User.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeUserResponse
  ): zio.aws.connect.model.DescribeUserResponse.ReadOnly = new Wrapper(impl)
}
