package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Dimensions(
    queue: Option[zio.aws.connect.model.QueueReference] = None,
    channel: Option[zio.aws.connect.model.Channel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.Dimensions = {
    import Dimensions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Dimensions
      .builder()
      .optionallyWith(queue.map(value => value.buildAwsValue()))(_.queue)
      .optionallyWith(channel.map(value => value.unwrap))(_.channel)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Dimensions.ReadOnly =
    zio.aws.connect.model.Dimensions.wrap(buildAwsValue())
}
object Dimensions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.Dimensions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Dimensions =
      zio.aws.connect.model.Dimensions(
        queue.map(value => value.asEditable),
        channel.map(value => value)
      )
    def queue: Option[zio.aws.connect.model.QueueReference.ReadOnly]
    def channel: Option[zio.aws.connect.model.Channel]
    def getQueue
        : ZIO[Any, AwsError, zio.aws.connect.model.QueueReference.ReadOnly] =
      AwsError.unwrapOptionField("queue", queue)
    def getChannel: ZIO[Any, AwsError, zio.aws.connect.model.Channel] =
      AwsError.unwrapOptionField("channel", channel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Dimensions
  ) extends zio.aws.connect.model.Dimensions.ReadOnly {
    override val queue: Option[zio.aws.connect.model.QueueReference.ReadOnly] =
      scala
        .Option(impl.queue())
        .map(value => zio.aws.connect.model.QueueReference.wrap(value))
    override val channel: Option[zio.aws.connect.model.Channel] = scala
      .Option(impl.channel())
      .map(value => zio.aws.connect.model.Channel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Dimensions
  ): zio.aws.connect.model.Dimensions.ReadOnly = new Wrapper(impl)
}
