package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{FunctionArn, InstanceId}
import scala.jdk.CollectionConverters._
final case class DisassociateLambdaFunctionRequest(
    instanceId: InstanceId,
    functionArn: FunctionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionRequest = {
    import DisassociateLambdaFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .functionArn(FunctionArn.unwrap(functionArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DisassociateLambdaFunctionRequest.ReadOnly =
    zio.aws.connect.model.DisassociateLambdaFunctionRequest
      .wrap(buildAwsValue())
}
object DisassociateLambdaFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DisassociateLambdaFunctionRequest =
      zio.aws.connect.model
        .DisassociateLambdaFunctionRequest(instanceId, functionArn)
    def instanceId: InstanceId
    def functionArn: FunctionArn
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getFunctionArn: ZIO[Any, Nothing, FunctionArn] =
      ZIO.succeed(functionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionRequest
  ) extends zio.aws.connect.model.DisassociateLambdaFunctionRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val functionArn: FunctionArn =
      zio.aws.connect.model.primitives.FunctionArn(impl.functionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionRequest
  ): zio.aws.connect.model.DisassociateLambdaFunctionRequest.ReadOnly =
    new Wrapper(impl)
}
