package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{AssociationId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DisassociateSecurityKeyRequest(
    instanceId: InstanceId,
    associationId: AssociationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyRequest = {
    import DisassociateSecurityKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .associationId(AssociationId.unwrap(associationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DisassociateSecurityKeyRequest.ReadOnly =
    zio.aws.connect.model.DisassociateSecurityKeyRequest.wrap(buildAwsValue())
}
object DisassociateSecurityKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DisassociateSecurityKeyRequest =
      zio.aws.connect.model
        .DisassociateSecurityKeyRequest(instanceId, associationId)
    def instanceId: InstanceId
    def associationId: AssociationId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getAssociationId: ZIO[Any, Nothing, AssociationId] =
      ZIO.succeed(associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyRequest
  ) extends zio.aws.connect.model.DisassociateSecurityKeyRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val associationId: AssociationId =
      zio.aws.connect.model.primitives.AssociationId(impl.associationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyRequest
  ): zio.aws.connect.model.DisassociateSecurityKeyRequest.ReadOnly =
    new Wrapper(impl)
}
