package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.QueueId
import scala.jdk.CollectionConverters._
final case class Filters(
    queues: Option[Iterable[QueueId]] = None,
    channels: Option[Iterable[zio.aws.connect.model.Channel]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.connect.model.Filters = {
    import Filters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Filters
      .builder()
      .optionallyWith(
        queues.map(value =>
          value.map { item =>
            QueueId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queues)
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.channelsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Filters.ReadOnly =
    zio.aws.connect.model.Filters.wrap(buildAwsValue())
}
object Filters {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.Filters] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Filters = zio.aws.connect.model
      .Filters(queues.map(value => value), channels.map(value => value))
    def queues: Option[List[QueueId]]
    def channels: Option[List[zio.aws.connect.model.Channel]]
    def getQueues: ZIO[Any, AwsError, List[QueueId]] =
      AwsError.unwrapOptionField("queues", queues)
    def getChannels: ZIO[Any, AwsError, List[zio.aws.connect.model.Channel]] =
      AwsError.unwrapOptionField("channels", channels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Filters
  ) extends zio.aws.connect.model.Filters.ReadOnly {
    override val queues: Option[List[QueueId]] = scala
      .Option(impl.queues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.QueueId(item)
        }.toList
      )
    override val channels: Option[List[zio.aws.connect.model.Channel]] = scala
      .Option(impl.channels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.Channel.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Filters
  ): zio.aws.connect.model.Filters.ReadOnly = new Wrapper(impl)
}
