package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ContactId, InstanceId}
import scala.jdk.CollectionConverters._
final case class GetContactAttributesRequest(
    instanceId: InstanceId,
    initialContactId: ContactId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetContactAttributesRequest = {
    import GetContactAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetContactAttributesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .initialContactId(ContactId.unwrap(initialContactId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetContactAttributesRequest.ReadOnly =
    zio.aws.connect.model.GetContactAttributesRequest.wrap(buildAwsValue())
}
object GetContactAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetContactAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetContactAttributesRequest =
      zio.aws.connect.model
        .GetContactAttributesRequest(instanceId, initialContactId)
    def instanceId: InstanceId
    def initialContactId: ContactId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getInitialContactId: ZIO[Any, Nothing, ContactId] =
      ZIO.succeed(initialContactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetContactAttributesRequest
  ) extends zio.aws.connect.model.GetContactAttributesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val initialContactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.initialContactId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetContactAttributesRequest
  ): zio.aws.connect.model.GetContactAttributesRequest.ReadOnly = new Wrapper(
    impl
  )
}
