package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.connect.model.primitives.{Timestamp, NextToken}
import scala.jdk.CollectionConverters._
final case class GetCurrentMetricDataResponse(
    nextToken: Option[NextToken] = None,
    metricResults: Option[Iterable[zio.aws.connect.model.CurrentMetricResult]] =
      None,
    dataSnapshotTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse = {
    import GetCurrentMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        metricResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricResults)
      .optionallyWith(
        dataSnapshotTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataSnapshotTime)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly =
    zio.aws.connect.model.GetCurrentMetricDataResponse.wrap(buildAwsValue())
}
object GetCurrentMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetCurrentMetricDataResponse =
      zio.aws.connect.model.GetCurrentMetricDataResponse(
        nextToken.map(value => value),
        metricResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataSnapshotTime.map(value => value)
      )
    def nextToken: Option[NextToken]
    def metricResults
        : Option[List[zio.aws.connect.model.CurrentMetricResult.ReadOnly]]
    def dataSnapshotTime: Option[Timestamp]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMetricResults: ZIO[Any, AwsError, List[
      zio.aws.connect.model.CurrentMetricResult.ReadOnly
    ]] = AwsError.unwrapOptionField("metricResults", metricResults)
    def getDataSnapshotTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataSnapshotTime", dataSnapshotTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse
  ) extends zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val metricResults
        : Option[List[zio.aws.connect.model.CurrentMetricResult.ReadOnly]] =
      scala
        .Option(impl.metricResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.CurrentMetricResult.wrap(item)
          }.toList
        )
    override val dataSnapshotTime: Option[Timestamp] = scala
      .Option(impl.dataSnapshotTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse
  ): zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly = new Wrapper(
    impl
  )
}
