package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.InstanceId
import scala.jdk.CollectionConverters._
final case class GetFederationTokenRequest(instanceId: InstanceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetFederationTokenRequest = {
    import GetFederationTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetFederationTokenRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetFederationTokenRequest.ReadOnly =
    zio.aws.connect.model.GetFederationTokenRequest.wrap(buildAwsValue())
}
object GetFederationTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetFederationTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetFederationTokenRequest =
      zio.aws.connect.model.GetFederationTokenRequest(instanceId)
    def instanceId: InstanceId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetFederationTokenRequest
  ) extends zio.aws.connect.model.GetFederationTokenRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetFederationTokenRequest
  ): zio.aws.connect.model.GetFederationTokenRequest.ReadOnly = new Wrapper(
    impl
  )
}
