package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class GetMetricDataResponse(
    nextToken: Option[NextToken] = None,
    metricResults: Option[
      Iterable[zio.aws.connect.model.HistoricalMetricResult]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetMetricDataResponse = {
    import GetMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetMetricDataResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        metricResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetMetricDataResponse.ReadOnly =
    zio.aws.connect.model.GetMetricDataResponse.wrap(buildAwsValue())
}
object GetMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetMetricDataResponse =
      zio.aws.connect.model.GetMetricDataResponse(
        nextToken.map(value => value),
        metricResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def metricResults
        : Option[List[zio.aws.connect.model.HistoricalMetricResult.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMetricResults: ZIO[Any, AwsError, List[
      zio.aws.connect.model.HistoricalMetricResult.ReadOnly
    ]] = AwsError.unwrapOptionField("metricResults", metricResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetMetricDataResponse
  ) extends zio.aws.connect.model.GetMetricDataResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val metricResults
        : Option[List[zio.aws.connect.model.HistoricalMetricResult.ReadOnly]] =
      scala
        .Option(impl.metricResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.HistoricalMetricResult.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetMetricDataResponse
  ): zio.aws.connect.model.GetMetricDataResponse.ReadOnly = new Wrapper(impl)
}
