package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  HierarchyLevelId,
  HierarchyGroupName,
  ARN,
  HierarchyGroupId
}
import scala.jdk.CollectionConverters._
final case class HierarchyGroup(
    id: Option[HierarchyGroupId] = None,
    arn: Option[ARN] = None,
    name: Option[HierarchyGroupName] = None,
    levelId: Option[HierarchyLevelId] = None,
    hierarchyPath: Option[zio.aws.connect.model.HierarchyPath] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HierarchyGroup = {
    import HierarchyGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HierarchyGroup
      .builder()
      .optionallyWith(
        id.map(value => HierarchyGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => HierarchyGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        levelId.map(value => HierarchyLevelId.unwrap(value): java.lang.String)
      )(_.levelId)
      .optionallyWith(hierarchyPath.map(value => value.buildAwsValue()))(
        _.hierarchyPath
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HierarchyGroup.ReadOnly =
    zio.aws.connect.model.HierarchyGroup.wrap(buildAwsValue())
}
object HierarchyGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HierarchyGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HierarchyGroup =
      zio.aws.connect.model.HierarchyGroup(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        levelId.map(value => value),
        hierarchyPath.map(value => value.asEditable)
      )
    def id: Option[HierarchyGroupId]
    def arn: Option[ARN]
    def name: Option[HierarchyGroupName]
    def levelId: Option[HierarchyLevelId]
    def hierarchyPath: Option[zio.aws.connect.model.HierarchyPath.ReadOnly]
    def getId: ZIO[Any, AwsError, HierarchyGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, HierarchyGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getLevelId: ZIO[Any, AwsError, HierarchyLevelId] =
      AwsError.unwrapOptionField("levelId", levelId)
    def getHierarchyPath
        : ZIO[Any, AwsError, zio.aws.connect.model.HierarchyPath.ReadOnly] =
      AwsError.unwrapOptionField("hierarchyPath", hierarchyPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HierarchyGroup
  ) extends zio.aws.connect.model.HierarchyGroup.ReadOnly {
    override val id: Option[HierarchyGroupId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.HierarchyGroupId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Option[HierarchyGroupName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.HierarchyGroupName(value))
    override val levelId: Option[HierarchyLevelId] = scala
      .Option(impl.levelId())
      .map(value => zio.aws.connect.model.primitives.HierarchyLevelId(value))
    override val hierarchyPath
        : Option[zio.aws.connect.model.HierarchyPath.ReadOnly] = scala
      .Option(impl.hierarchyPath())
      .map(value => zio.aws.connect.model.HierarchyPath.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HierarchyGroup
  ): zio.aws.connect.model.HierarchyGroup.ReadOnly = new Wrapper(impl)
}
