package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  HierarchyGroupName,
  ARN,
  HierarchyGroupId
}
import scala.jdk.CollectionConverters._
final case class HierarchyGroupSummary(
    id: Option[HierarchyGroupId] = None,
    arn: Option[ARN] = None,
    name: Option[HierarchyGroupName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HierarchyGroupSummary = {
    import HierarchyGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HierarchyGroupSummary
      .builder()
      .optionallyWith(
        id.map(value => HierarchyGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => HierarchyGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HierarchyGroupSummary.ReadOnly =
    zio.aws.connect.model.HierarchyGroupSummary.wrap(buildAwsValue())
}
object HierarchyGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HierarchyGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HierarchyGroupSummary =
      zio.aws.connect.model.HierarchyGroupSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value)
      )
    def id: Option[HierarchyGroupId]
    def arn: Option[ARN]
    def name: Option[HierarchyGroupName]
    def getId: ZIO[Any, AwsError, HierarchyGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, HierarchyGroupName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HierarchyGroupSummary
  ) extends zio.aws.connect.model.HierarchyGroupSummary.ReadOnly {
    override val id: Option[HierarchyGroupId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.HierarchyGroupId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Option[HierarchyGroupName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.HierarchyGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HierarchyGroupSummary
  ): zio.aws.connect.model.HierarchyGroupSummary.ReadOnly = new Wrapper(impl)
}
