package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  HierarchyLevelName,
  ARN,
  HierarchyLevelId
}
import scala.jdk.CollectionConverters._
final case class HierarchyLevel(
    id: Option[HierarchyLevelId] = None,
    arn: Option[ARN] = None,
    name: Option[HierarchyLevelName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HierarchyLevel = {
    import HierarchyLevel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HierarchyLevel
      .builder()
      .optionallyWith(
        id.map(value => HierarchyLevelId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => HierarchyLevelName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HierarchyLevel.ReadOnly =
    zio.aws.connect.model.HierarchyLevel.wrap(buildAwsValue())
}
object HierarchyLevel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HierarchyLevel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HierarchyLevel =
      zio.aws.connect.model.HierarchyLevel(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value)
      )
    def id: Option[HierarchyLevelId]
    def arn: Option[ARN]
    def name: Option[HierarchyLevelName]
    def getId: ZIO[Any, AwsError, HierarchyLevelId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, HierarchyLevelName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HierarchyLevel
  ) extends zio.aws.connect.model.HierarchyLevel.ReadOnly {
    override val id: Option[HierarchyLevelId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.HierarchyLevelId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Option[HierarchyLevelName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.HierarchyLevelName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HierarchyLevel
  ): zio.aws.connect.model.HierarchyLevel.ReadOnly = new Wrapper(impl)
}
