package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HierarchyPath(
    levelOne: Option[zio.aws.connect.model.HierarchyGroupSummary] = None,
    levelTwo: Option[zio.aws.connect.model.HierarchyGroupSummary] = None,
    levelThree: Option[zio.aws.connect.model.HierarchyGroupSummary] = None,
    levelFour: Option[zio.aws.connect.model.HierarchyGroupSummary] = None,
    levelFive: Option[zio.aws.connect.model.HierarchyGroupSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HierarchyPath = {
    import HierarchyPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HierarchyPath
      .builder()
      .optionallyWith(levelOne.map(value => value.buildAwsValue()))(_.levelOne)
      .optionallyWith(levelTwo.map(value => value.buildAwsValue()))(_.levelTwo)
      .optionallyWith(levelThree.map(value => value.buildAwsValue()))(
        _.levelThree
      )
      .optionallyWith(levelFour.map(value => value.buildAwsValue()))(
        _.levelFour
      )
      .optionallyWith(levelFive.map(value => value.buildAwsValue()))(
        _.levelFive
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HierarchyPath.ReadOnly =
    zio.aws.connect.model.HierarchyPath.wrap(buildAwsValue())
}
object HierarchyPath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HierarchyPath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HierarchyPath =
      zio.aws.connect.model.HierarchyPath(
        levelOne.map(value => value.asEditable),
        levelTwo.map(value => value.asEditable),
        levelThree.map(value => value.asEditable),
        levelFour.map(value => value.asEditable),
        levelFive.map(value => value.asEditable)
      )
    def levelOne: Option[zio.aws.connect.model.HierarchyGroupSummary.ReadOnly]
    def levelTwo: Option[zio.aws.connect.model.HierarchyGroupSummary.ReadOnly]
    def levelThree: Option[zio.aws.connect.model.HierarchyGroupSummary.ReadOnly]
    def levelFour: Option[zio.aws.connect.model.HierarchyGroupSummary.ReadOnly]
    def levelFive: Option[zio.aws.connect.model.HierarchyGroupSummary.ReadOnly]
    def getLevelOne: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyGroupSummary.ReadOnly
    ] = AwsError.unwrapOptionField("levelOne", levelOne)
    def getLevelTwo: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyGroupSummary.ReadOnly
    ] = AwsError.unwrapOptionField("levelTwo", levelTwo)
    def getLevelThree: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyGroupSummary.ReadOnly
    ] = AwsError.unwrapOptionField("levelThree", levelThree)
    def getLevelFour: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyGroupSummary.ReadOnly
    ] = AwsError.unwrapOptionField("levelFour", levelFour)
    def getLevelFive: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyGroupSummary.ReadOnly
    ] = AwsError.unwrapOptionField("levelFive", levelFive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HierarchyPath
  ) extends zio.aws.connect.model.HierarchyPath.ReadOnly {
    override val levelOne
        : Option[zio.aws.connect.model.HierarchyGroupSummary.ReadOnly] = scala
      .Option(impl.levelOne())
      .map(value => zio.aws.connect.model.HierarchyGroupSummary.wrap(value))
    override val levelTwo
        : Option[zio.aws.connect.model.HierarchyGroupSummary.ReadOnly] = scala
      .Option(impl.levelTwo())
      .map(value => zio.aws.connect.model.HierarchyGroupSummary.wrap(value))
    override val levelThree
        : Option[zio.aws.connect.model.HierarchyGroupSummary.ReadOnly] = scala
      .Option(impl.levelThree())
      .map(value => zio.aws.connect.model.HierarchyGroupSummary.wrap(value))
    override val levelFour
        : Option[zio.aws.connect.model.HierarchyGroupSummary.ReadOnly] = scala
      .Option(impl.levelFour())
      .map(value => zio.aws.connect.model.HierarchyGroupSummary.wrap(value))
    override val levelFive
        : Option[zio.aws.connect.model.HierarchyGroupSummary.ReadOnly] = scala
      .Option(impl.levelFive())
      .map(value => zio.aws.connect.model.HierarchyGroupSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HierarchyPath
  ): zio.aws.connect.model.HierarchyPath.ReadOnly = new Wrapper(impl)
}
