package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HierarchyStructureUpdate(
    levelOne: Option[zio.aws.connect.model.HierarchyLevelUpdate] = None,
    levelTwo: Option[zio.aws.connect.model.HierarchyLevelUpdate] = None,
    levelThree: Option[zio.aws.connect.model.HierarchyLevelUpdate] = None,
    levelFour: Option[zio.aws.connect.model.HierarchyLevelUpdate] = None,
    levelFive: Option[zio.aws.connect.model.HierarchyLevelUpdate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HierarchyStructureUpdate = {
    import HierarchyStructureUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HierarchyStructureUpdate
      .builder()
      .optionallyWith(levelOne.map(value => value.buildAwsValue()))(_.levelOne)
      .optionallyWith(levelTwo.map(value => value.buildAwsValue()))(_.levelTwo)
      .optionallyWith(levelThree.map(value => value.buildAwsValue()))(
        _.levelThree
      )
      .optionallyWith(levelFour.map(value => value.buildAwsValue()))(
        _.levelFour
      )
      .optionallyWith(levelFive.map(value => value.buildAwsValue()))(
        _.levelFive
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HierarchyStructureUpdate.ReadOnly =
    zio.aws.connect.model.HierarchyStructureUpdate.wrap(buildAwsValue())
}
object HierarchyStructureUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HierarchyStructureUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HierarchyStructureUpdate =
      zio.aws.connect.model.HierarchyStructureUpdate(
        levelOne.map(value => value.asEditable),
        levelTwo.map(value => value.asEditable),
        levelThree.map(value => value.asEditable),
        levelFour.map(value => value.asEditable),
        levelFive.map(value => value.asEditable)
      )
    def levelOne: Option[zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly]
    def levelTwo: Option[zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly]
    def levelThree: Option[zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly]
    def levelFour: Option[zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly]
    def levelFive: Option[zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly]
    def getLevelOne: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("levelOne", levelOne)
    def getLevelTwo: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("levelTwo", levelTwo)
    def getLevelThree: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("levelThree", levelThree)
    def getLevelFour: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("levelFour", levelFour)
    def getLevelFive: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("levelFive", levelFive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HierarchyStructureUpdate
  ) extends zio.aws.connect.model.HierarchyStructureUpdate.ReadOnly {
    override val levelOne
        : Option[zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly] = scala
      .Option(impl.levelOne())
      .map(value => zio.aws.connect.model.HierarchyLevelUpdate.wrap(value))
    override val levelTwo
        : Option[zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly] = scala
      .Option(impl.levelTwo())
      .map(value => zio.aws.connect.model.HierarchyLevelUpdate.wrap(value))
    override val levelThree
        : Option[zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly] = scala
      .Option(impl.levelThree())
      .map(value => zio.aws.connect.model.HierarchyLevelUpdate.wrap(value))
    override val levelFour
        : Option[zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly] = scala
      .Option(impl.levelFour())
      .map(value => zio.aws.connect.model.HierarchyLevelUpdate.wrap(value))
    override val levelFive
        : Option[zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly] = scala
      .Option(impl.levelFive())
      .map(value => zio.aws.connect.model.HierarchyLevelUpdate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HierarchyStructureUpdate
  ): zio.aws.connect.model.HierarchyStructureUpdate.ReadOnly = new Wrapper(impl)
}
