package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HistoricalMetric(
    name: Option[zio.aws.connect.model.HistoricalMetricName] = None,
    threshold: Option[zio.aws.connect.model.Threshold] = None,
    statistic: Option[zio.aws.connect.model.Statistic] = None,
    unit: Option[zio.aws.connect.model.Unit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HistoricalMetric = {
    import HistoricalMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HistoricalMetric
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(threshold.map(value => value.buildAwsValue()))(
        _.threshold
      )
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HistoricalMetric.ReadOnly =
    zio.aws.connect.model.HistoricalMetric.wrap(buildAwsValue())
}
object HistoricalMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HistoricalMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HistoricalMetric =
      zio.aws.connect.model.HistoricalMetric(
        name.map(value => value),
        threshold.map(value => value.asEditable),
        statistic.map(value => value),
        unit.map(value => value)
      )
    def name: Option[zio.aws.connect.model.HistoricalMetricName]
    def threshold: Option[zio.aws.connect.model.Threshold.ReadOnly]
    def statistic: Option[zio.aws.connect.model.Statistic]
    def unit: Option[zio.aws.connect.model.Unit]
    def getName
        : ZIO[Any, AwsError, zio.aws.connect.model.HistoricalMetricName] =
      AwsError.unwrapOptionField("name", name)
    def getThreshold
        : ZIO[Any, AwsError, zio.aws.connect.model.Threshold.ReadOnly] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getStatistic: ZIO[Any, AwsError, zio.aws.connect.model.Statistic] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getUnit: ZIO[Any, AwsError, zio.aws.connect.model.Unit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HistoricalMetric
  ) extends zio.aws.connect.model.HistoricalMetric.ReadOnly {
    override val name: Option[zio.aws.connect.model.HistoricalMetricName] =
      scala
        .Option(impl.name())
        .map(value => zio.aws.connect.model.HistoricalMetricName.wrap(value))
    override val threshold: Option[zio.aws.connect.model.Threshold.ReadOnly] =
      scala
        .Option(impl.threshold())
        .map(value => zio.aws.connect.model.Threshold.wrap(value))
    override val statistic: Option[zio.aws.connect.model.Statistic] = scala
      .Option(impl.statistic())
      .map(value => zio.aws.connect.model.Statistic.wrap(value))
    override val unit: Option[zio.aws.connect.model.Unit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.connect.model.Unit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HistoricalMetric
  ): zio.aws.connect.model.HistoricalMetric.ReadOnly = new Wrapper(impl)
}
