package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.Value
import scala.jdk.CollectionConverters._
final case class HistoricalMetricData(
    metric: Option[zio.aws.connect.model.HistoricalMetric] = None,
    value: Option[Value] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HistoricalMetricData = {
    import HistoricalMetricData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HistoricalMetricData
      .builder()
      .optionallyWith(metric.map(value => value.buildAwsValue()))(_.metric)
      .optionallyWith(
        value.map(value => Value.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HistoricalMetricData.ReadOnly =
    zio.aws.connect.model.HistoricalMetricData.wrap(buildAwsValue())
}
object HistoricalMetricData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HistoricalMetricData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HistoricalMetricData =
      zio.aws.connect.model.HistoricalMetricData(
        metric.map(value => value.asEditable),
        value.map(value => value)
      )
    def metric: Option[zio.aws.connect.model.HistoricalMetric.ReadOnly]
    def value: Option[Value]
    def getMetric
        : ZIO[Any, AwsError, zio.aws.connect.model.HistoricalMetric.ReadOnly] =
      AwsError.unwrapOptionField("metric", metric)
    def getValue: ZIO[Any, AwsError, Value] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HistoricalMetricData
  ) extends zio.aws.connect.model.HistoricalMetricData.ReadOnly {
    override val metric
        : Option[zio.aws.connect.model.HistoricalMetric.ReadOnly] = scala
      .Option(impl.metric())
      .map(value => zio.aws.connect.model.HistoricalMetric.wrap(value))
    override val value: Option[Value] = scala
      .Option(impl.value())
      .map(value => zio.aws.connect.model.primitives.Value(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HistoricalMetricData
  ): zio.aws.connect.model.HistoricalMetricData.ReadOnly = new Wrapper(impl)
}
