package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HistoricalMetricResult(
    dimensions: Option[zio.aws.connect.model.Dimensions] = None,
    collections: Option[Iterable[zio.aws.connect.model.HistoricalMetricData]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HistoricalMetricResult = {
    import HistoricalMetricResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HistoricalMetricResult
      .builder()
      .optionallyWith(dimensions.map(value => value.buildAwsValue()))(
        _.dimensions
      )
      .optionallyWith(
        collections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.collections)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HistoricalMetricResult.ReadOnly =
    zio.aws.connect.model.HistoricalMetricResult.wrap(buildAwsValue())
}
object HistoricalMetricResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HistoricalMetricResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HistoricalMetricResult =
      zio.aws.connect.model.HistoricalMetricResult(
        dimensions.map(value => value.asEditable),
        collections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dimensions: Option[zio.aws.connect.model.Dimensions.ReadOnly]
    def collections
        : Option[List[zio.aws.connect.model.HistoricalMetricData.ReadOnly]]
    def getDimensions
        : ZIO[Any, AwsError, zio.aws.connect.model.Dimensions.ReadOnly] =
      AwsError.unwrapOptionField("dimensions", dimensions)
    def getCollections: ZIO[Any, AwsError, List[
      zio.aws.connect.model.HistoricalMetricData.ReadOnly
    ]] = AwsError.unwrapOptionField("collections", collections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HistoricalMetricResult
  ) extends zio.aws.connect.model.HistoricalMetricResult.ReadOnly {
    override val dimensions: Option[zio.aws.connect.model.Dimensions.ReadOnly] =
      scala
        .Option(impl.dimensions())
        .map(value => zio.aws.connect.model.Dimensions.wrap(value))
    override val collections
        : Option[List[zio.aws.connect.model.HistoricalMetricData.ReadOnly]] =
      scala
        .Option(impl.collections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.HistoricalMetricData.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HistoricalMetricResult
  ): zio.aws.connect.model.HistoricalMetricResult.ReadOnly = new Wrapper(impl)
}
