package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  HoursOfOperationDescription,
  HoursOfOperationId,
  TagValue,
  TimeZone,
  CommonNameLength127,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class HoursOfOperation(
    hoursOfOperationId: Option[HoursOfOperationId] = None,
    hoursOfOperationArn: Option[ARN] = None,
    name: Option[CommonNameLength127] = None,
    description: Option[HoursOfOperationDescription] = None,
    timeZone: Option[TimeZone] = None,
    config: Option[Iterable[zio.aws.connect.model.HoursOfOperationConfig]] =
      None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HoursOfOperation = {
    import HoursOfOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HoursOfOperation
      .builder()
      .optionallyWith(
        hoursOfOperationId.map(value =>
          HoursOfOperationId.unwrap(value): java.lang.String
        )
      )(_.hoursOfOperationId)
      .optionallyWith(
        hoursOfOperationArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.hoursOfOperationArn)
      .optionallyWith(
        name.map(value => CommonNameLength127.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          HoursOfOperationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        timeZone.map(value => TimeZone.unwrap(value): java.lang.String)
      )(_.timeZone)
      .optionallyWith(
        config.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.config)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HoursOfOperation.ReadOnly =
    zio.aws.connect.model.HoursOfOperation.wrap(buildAwsValue())
}
object HoursOfOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HoursOfOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HoursOfOperation =
      zio.aws.connect.model.HoursOfOperation(
        hoursOfOperationId.map(value => value),
        hoursOfOperationArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        timeZone.map(value => value),
        config.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def hoursOfOperationId: Option[HoursOfOperationId]
    def hoursOfOperationArn: Option[ARN]
    def name: Option[CommonNameLength127]
    def description: Option[HoursOfOperationDescription]
    def timeZone: Option[TimeZone]
    def config
        : Option[List[zio.aws.connect.model.HoursOfOperationConfig.ReadOnly]]
    def tags: Option[Map[TagKey, TagValue]]
    def getHoursOfOperationId: ZIO[Any, AwsError, HoursOfOperationId] =
      AwsError.unwrapOptionField("hoursOfOperationId", hoursOfOperationId)
    def getHoursOfOperationArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("hoursOfOperationArn", hoursOfOperationArn)
    def getName: ZIO[Any, AwsError, CommonNameLength127] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, HoursOfOperationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTimeZone: ZIO[Any, AwsError, TimeZone] =
      AwsError.unwrapOptionField("timeZone", timeZone)
    def getConfig: ZIO[Any, AwsError, List[
      zio.aws.connect.model.HoursOfOperationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("config", config)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HoursOfOperation
  ) extends zio.aws.connect.model.HoursOfOperation.ReadOnly {
    override val hoursOfOperationId: Option[HoursOfOperationId] = scala
      .Option(impl.hoursOfOperationId())
      .map(value => zio.aws.connect.model.primitives.HoursOfOperationId(value))
    override val hoursOfOperationArn: Option[ARN] = scala
      .Option(impl.hoursOfOperationArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Option[CommonNameLength127] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.CommonNameLength127(value))
    override val description: Option[HoursOfOperationDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.connect.model.primitives.HoursOfOperationDescription(value)
      )
    override val timeZone: Option[TimeZone] = scala
      .Option(impl.timeZone())
      .map(value => zio.aws.connect.model.primitives.TimeZone(value))
    override val config
        : Option[List[zio.aws.connect.model.HoursOfOperationConfig.ReadOnly]] =
      scala
        .Option(impl.config())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.HoursOfOperationConfig.wrap(item)
          }.toList
        )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HoursOfOperation
  ): zio.aws.connect.model.HoursOfOperation.ReadOnly = new Wrapper(impl)
}
