package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  HoursOfOperationName,
  ARN,
  HoursOfOperationId
}
import scala.jdk.CollectionConverters._
final case class HoursOfOperationSummary(
    id: Option[HoursOfOperationId] = None,
    arn: Option[ARN] = None,
    name: Option[HoursOfOperationName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HoursOfOperationSummary = {
    import HoursOfOperationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HoursOfOperationSummary
      .builder()
      .optionallyWith(
        id.map(value => HoursOfOperationId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => HoursOfOperationName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HoursOfOperationSummary.ReadOnly =
    zio.aws.connect.model.HoursOfOperationSummary.wrap(buildAwsValue())
}
object HoursOfOperationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HoursOfOperationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HoursOfOperationSummary =
      zio.aws.connect.model.HoursOfOperationSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value)
      )
    def id: Option[HoursOfOperationId]
    def arn: Option[ARN]
    def name: Option[HoursOfOperationName]
    def getId: ZIO[Any, AwsError, HoursOfOperationId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, HoursOfOperationName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HoursOfOperationSummary
  ) extends zio.aws.connect.model.HoursOfOperationSummary.ReadOnly {
    override val id: Option[HoursOfOperationId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.HoursOfOperationId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Option[HoursOfOperationName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.connect.model.primitives.HoursOfOperationName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HoursOfOperationSummary
  ): zio.aws.connect.model.HoursOfOperationSummary.ReadOnly = new Wrapper(impl)
}
