package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait InstanceAttributeType {
  def unwrap
      : software.amazon.awssdk.services.connect.model.InstanceAttributeType
}
object InstanceAttributeType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.InstanceAttributeType
  ): zio.aws.connect.model.InstanceAttributeType = value match {
    case software.amazon.awssdk.services.connect.model.InstanceAttributeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.InstanceAttributeType.INBOUND_CALLS =>
      val r = INBOUND_CALLS
      r
    case software.amazon.awssdk.services.connect.model.InstanceAttributeType.OUTBOUND_CALLS =>
      val r = OUTBOUND_CALLS
      r
    case software.amazon.awssdk.services.connect.model.InstanceAttributeType.CONTACTFLOW_LOGS =>
      val r = CONTACTFLOW_LOGS
      r
    case software.amazon.awssdk.services.connect.model.InstanceAttributeType.CONTACT_LENS =>
      val r = CONTACT_LENS
      r
    case software.amazon.awssdk.services.connect.model.InstanceAttributeType.AUTO_RESOLVE_BEST_VOICES =>
      val r = AUTO_RESOLVE_BEST_VOICES
      r
    case software.amazon.awssdk.services.connect.model.InstanceAttributeType.USE_CUSTOM_TTS_VOICES =>
      val r = USE_CUSTOM_TTS_VOICES
      r
    case software.amazon.awssdk.services.connect.model.InstanceAttributeType.EARLY_MEDIA =>
      val r = EARLY_MEDIA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.InstanceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceAttributeType =
      software.amazon.awssdk.services.connect.model.InstanceAttributeType.UNKNOWN_TO_SDK_VERSION
  }
  case object INBOUND_CALLS
      extends zio.aws.connect.model.InstanceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceAttributeType =
      software.amazon.awssdk.services.connect.model.InstanceAttributeType.INBOUND_CALLS
  }
  case object OUTBOUND_CALLS
      extends zio.aws.connect.model.InstanceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceAttributeType =
      software.amazon.awssdk.services.connect.model.InstanceAttributeType.OUTBOUND_CALLS
  }
  case object CONTACTFLOW_LOGS
      extends zio.aws.connect.model.InstanceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceAttributeType =
      software.amazon.awssdk.services.connect.model.InstanceAttributeType.CONTACTFLOW_LOGS
  }
  case object CONTACT_LENS extends zio.aws.connect.model.InstanceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceAttributeType =
      software.amazon.awssdk.services.connect.model.InstanceAttributeType.CONTACT_LENS
  }
  case object AUTO_RESOLVE_BEST_VOICES
      extends zio.aws.connect.model.InstanceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceAttributeType =
      software.amazon.awssdk.services.connect.model.InstanceAttributeType.AUTO_RESOLVE_BEST_VOICES
  }
  case object USE_CUSTOM_TTS_VOICES
      extends zio.aws.connect.model.InstanceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceAttributeType =
      software.amazon.awssdk.services.connect.model.InstanceAttributeType.USE_CUSTOM_TTS_VOICES
  }
  case object EARLY_MEDIA extends zio.aws.connect.model.InstanceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceAttributeType =
      software.amazon.awssdk.services.connect.model.InstanceAttributeType.EARLY_MEDIA
  }
}
