package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceStatusReason(message: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.InstanceStatusReason = {
    import InstanceStatusReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.InstanceStatusReason
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.InstanceStatusReason.ReadOnly =
    zio.aws.connect.model.InstanceStatusReason.wrap(buildAwsValue())
}
object InstanceStatusReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.InstanceStatusReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.InstanceStatusReason =
      zio.aws.connect.model.InstanceStatusReason(message.map(value => value))
    def message: Option[String]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.InstanceStatusReason
  ) extends zio.aws.connect.model.InstanceStatusReason.ReadOnly {
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.InstanceStatusReason
  ): zio.aws.connect.model.InstanceStatusReason.ReadOnly = new Wrapper(impl)
}
