package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait InstanceStorageResourceType {
  def unwrap: software.amazon.awssdk.services.connect.model.InstanceStorageResourceType
}
object InstanceStorageResourceType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.InstanceStorageResourceType
  ): zio.aws.connect.model.InstanceStorageResourceType = value match {
    case software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.CHAT_TRANSCRIPTS =>
      val r = CHAT_TRANSCRIPTS
      r
    case software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.CALL_RECORDINGS =>
      val r = CALL_RECORDINGS
      r
    case software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.SCHEDULED_REPORTS =>
      val r = SCHEDULED_REPORTS
      r
    case software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.MEDIA_STREAMS =>
      val r = MEDIA_STREAMS
      r
    case software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.CONTACT_TRACE_RECORDS =>
      val r = CONTACT_TRACE_RECORDS
      r
    case software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.AGENT_EVENTS =>
      val r = AGENT_EVENTS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.InstanceStorageResourceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceStorageResourceType =
      software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object CHAT_TRANSCRIPTS
      extends zio.aws.connect.model.InstanceStorageResourceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceStorageResourceType =
      software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.CHAT_TRANSCRIPTS
  }
  case object CALL_RECORDINGS
      extends zio.aws.connect.model.InstanceStorageResourceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceStorageResourceType =
      software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.CALL_RECORDINGS
  }
  case object SCHEDULED_REPORTS
      extends zio.aws.connect.model.InstanceStorageResourceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceStorageResourceType =
      software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.SCHEDULED_REPORTS
  }
  case object MEDIA_STREAMS
      extends zio.aws.connect.model.InstanceStorageResourceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceStorageResourceType =
      software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.MEDIA_STREAMS
  }
  case object CONTACT_TRACE_RECORDS
      extends zio.aws.connect.model.InstanceStorageResourceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceStorageResourceType =
      software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.CONTACT_TRACE_RECORDS
  }
  case object AGENT_EVENTS
      extends zio.aws.connect.model.InstanceStorageResourceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceStorageResourceType =
      software.amazon.awssdk.services.connect.model.InstanceStorageResourceType.AGENT_EVENTS
  }
}
