package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.connect.model.primitives.{
  DirectoryAlias,
  InstanceId,
  Timestamp,
  InboundCallsEnabled,
  OutboundCallsEnabled,
  ARN
}
import scala.jdk.CollectionConverters._
final case class InstanceSummary(
    id: Option[InstanceId] = None,
    arn: Option[ARN] = None,
    identityManagementType: Option[zio.aws.connect.model.DirectoryType] = None,
    instanceAlias: Option[DirectoryAlias] = None,
    createdTime: Option[Timestamp] = None,
    serviceRole: Option[ARN] = None,
    instanceStatus: Option[zio.aws.connect.model.InstanceStatus] = None,
    inboundCallsEnabled: Option[InboundCallsEnabled] = None,
    outboundCallsEnabled: Option[OutboundCallsEnabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.InstanceSummary = {
    import InstanceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.InstanceSummary
      .builder()
      .optionallyWith(
        id.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(identityManagementType.map(value => value.unwrap))(
        _.identityManagementType
      )
      .optionallyWith(
        instanceAlias.map(value =>
          DirectoryAlias.unwrap(value): java.lang.String
        )
      )(_.instanceAlias)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        serviceRole.map(value => ARN.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(instanceStatus.map(value => value.unwrap))(
        _.instanceStatus
      )
      .optionallyWith(
        inboundCallsEnabled.map(value =>
          InboundCallsEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.inboundCallsEnabled)
      .optionallyWith(
        outboundCallsEnabled.map(value =>
          OutboundCallsEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.outboundCallsEnabled)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.InstanceSummary.ReadOnly =
    zio.aws.connect.model.InstanceSummary.wrap(buildAwsValue())
}
object InstanceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.InstanceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.InstanceSummary =
      zio.aws.connect.model.InstanceSummary(
        id.map(value => value),
        arn.map(value => value),
        identityManagementType.map(value => value),
        instanceAlias.map(value => value),
        createdTime.map(value => value),
        serviceRole.map(value => value),
        instanceStatus.map(value => value),
        inboundCallsEnabled.map(value => value),
        outboundCallsEnabled.map(value => value)
      )
    def id: Option[InstanceId]
    def arn: Option[ARN]
    def identityManagementType: Option[zio.aws.connect.model.DirectoryType]
    def instanceAlias: Option[DirectoryAlias]
    def createdTime: Option[Timestamp]
    def serviceRole: Option[ARN]
    def instanceStatus: Option[zio.aws.connect.model.InstanceStatus]
    def inboundCallsEnabled: Option[InboundCallsEnabled]
    def outboundCallsEnabled: Option[OutboundCallsEnabled]
    def getId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getIdentityManagementType
        : ZIO[Any, AwsError, zio.aws.connect.model.DirectoryType] = AwsError
      .unwrapOptionField("identityManagementType", identityManagementType)
    def getInstanceAlias: ZIO[Any, AwsError, DirectoryAlias] =
      AwsError.unwrapOptionField("instanceAlias", instanceAlias)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getServiceRole: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getInstanceStatus
        : ZIO[Any, AwsError, zio.aws.connect.model.InstanceStatus] =
      AwsError.unwrapOptionField("instanceStatus", instanceStatus)
    def getInboundCallsEnabled: ZIO[Any, AwsError, InboundCallsEnabled] =
      AwsError.unwrapOptionField("inboundCallsEnabled", inboundCallsEnabled)
    def getOutboundCallsEnabled: ZIO[Any, AwsError, OutboundCallsEnabled] =
      AwsError.unwrapOptionField("outboundCallsEnabled", outboundCallsEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.InstanceSummary
  ) extends zio.aws.connect.model.InstanceSummary.ReadOnly {
    override val id: Option[InstanceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.InstanceId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val identityManagementType
        : Option[zio.aws.connect.model.DirectoryType] = scala
      .Option(impl.identityManagementType())
      .map(value => zio.aws.connect.model.DirectoryType.wrap(value))
    override val instanceAlias: Option[DirectoryAlias] = scala
      .Option(impl.instanceAlias())
      .map(value => zio.aws.connect.model.primitives.DirectoryAlias(value))
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val serviceRole: Option[ARN] = scala
      .Option(impl.serviceRole())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val instanceStatus: Option[zio.aws.connect.model.InstanceStatus] =
      scala
        .Option(impl.instanceStatus())
        .map(value => zio.aws.connect.model.InstanceStatus.wrap(value))
    override val inboundCallsEnabled: Option[InboundCallsEnabled] = scala
      .Option(impl.inboundCallsEnabled())
      .map(value => zio.aws.connect.model.primitives.InboundCallsEnabled(value))
    override val outboundCallsEnabled: Option[OutboundCallsEnabled] = scala
      .Option(impl.outboundCallsEnabled())
      .map(value =>
        zio.aws.connect.model.primitives.OutboundCallsEnabled(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.InstanceSummary
  ): zio.aws.connect.model.InstanceSummary.ReadOnly = new Wrapper(impl)
}
