package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  SourceApplicationName,
  IntegrationAssociationId,
  InstanceId,
  URI,
  ARN
}
import scala.jdk.CollectionConverters._
final case class IntegrationAssociationSummary(
    integrationAssociationId: Option[IntegrationAssociationId] = None,
    integrationAssociationArn: Option[ARN] = None,
    instanceId: Option[InstanceId] = None,
    integrationType: Option[zio.aws.connect.model.IntegrationType] = None,
    integrationArn: Option[ARN] = None,
    sourceApplicationUrl: Option[URI] = None,
    sourceApplicationName: Option[SourceApplicationName] = None,
    sourceType: Option[zio.aws.connect.model.SourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.IntegrationAssociationSummary = {
    import IntegrationAssociationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.IntegrationAssociationSummary
      .builder()
      .optionallyWith(
        integrationAssociationId.map(value =>
          IntegrationAssociationId.unwrap(value): java.lang.String
        )
      )(_.integrationAssociationId)
      .optionallyWith(
        integrationAssociationArn.map(value =>
          ARN.unwrap(value): java.lang.String
        )
      )(_.integrationAssociationArn)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(integrationType.map(value => value.unwrap))(
        _.integrationType
      )
      .optionallyWith(
        integrationArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.integrationArn)
      .optionallyWith(
        sourceApplicationUrl.map(value => URI.unwrap(value): java.lang.String)
      )(_.sourceApplicationUrl)
      .optionallyWith(
        sourceApplicationName.map(value =>
          SourceApplicationName.unwrap(value): java.lang.String
        )
      )(_.sourceApplicationName)
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly =
    zio.aws.connect.model.IntegrationAssociationSummary.wrap(buildAwsValue())
}
object IntegrationAssociationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.IntegrationAssociationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.IntegrationAssociationSummary =
      zio.aws.connect.model.IntegrationAssociationSummary(
        integrationAssociationId.map(value => value),
        integrationAssociationArn.map(value => value),
        instanceId.map(value => value),
        integrationType.map(value => value),
        integrationArn.map(value => value),
        sourceApplicationUrl.map(value => value),
        sourceApplicationName.map(value => value),
        sourceType.map(value => value)
      )
    def integrationAssociationId: Option[IntegrationAssociationId]
    def integrationAssociationArn: Option[ARN]
    def instanceId: Option[InstanceId]
    def integrationType: Option[zio.aws.connect.model.IntegrationType]
    def integrationArn: Option[ARN]
    def sourceApplicationUrl: Option[URI]
    def sourceApplicationName: Option[SourceApplicationName]
    def sourceType: Option[zio.aws.connect.model.SourceType]
    def getIntegrationAssociationId
        : ZIO[Any, AwsError, IntegrationAssociationId] = AwsError
      .unwrapOptionField("integrationAssociationId", integrationAssociationId)
    def getIntegrationAssociationArn: ZIO[Any, AwsError, ARN] = AwsError
      .unwrapOptionField("integrationAssociationArn", integrationAssociationArn)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getIntegrationType
        : ZIO[Any, AwsError, zio.aws.connect.model.IntegrationType] =
      AwsError.unwrapOptionField("integrationType", integrationType)
    def getIntegrationArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("integrationArn", integrationArn)
    def getSourceApplicationUrl: ZIO[Any, AwsError, URI] =
      AwsError.unwrapOptionField("sourceApplicationUrl", sourceApplicationUrl)
    def getSourceApplicationName: ZIO[Any, AwsError, SourceApplicationName] =
      AwsError.unwrapOptionField("sourceApplicationName", sourceApplicationName)
    def getSourceType: ZIO[Any, AwsError, zio.aws.connect.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.IntegrationAssociationSummary
  ) extends zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly {
    override val integrationAssociationId: Option[IntegrationAssociationId] =
      scala
        .Option(impl.integrationAssociationId())
        .map(value =>
          zio.aws.connect.model.primitives.IntegrationAssociationId(value)
        )
    override val integrationAssociationArn: Option[ARN] = scala
      .Option(impl.integrationAssociationArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.connect.model.primitives.InstanceId(value))
    override val integrationType
        : Option[zio.aws.connect.model.IntegrationType] = scala
      .Option(impl.integrationType())
      .map(value => zio.aws.connect.model.IntegrationType.wrap(value))
    override val integrationArn: Option[ARN] = scala
      .Option(impl.integrationArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val sourceApplicationUrl: Option[URI] = scala
      .Option(impl.sourceApplicationUrl())
      .map(value => zio.aws.connect.model.primitives.URI(value))
    override val sourceApplicationName: Option[SourceApplicationName] = scala
      .Option(impl.sourceApplicationName())
      .map(value =>
        zio.aws.connect.model.primitives.SourceApplicationName(value)
      )
    override val sourceType: Option[zio.aws.connect.model.SourceType] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.connect.model.SourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.IntegrationAssociationSummary
  ): zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly = new Wrapper(
    impl
  )
}
