package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{LexRegion, BotName}
import scala.jdk.CollectionConverters._
final case class LexBot(
    name: Option[BotName] = None,
    lexRegion: Option[LexRegion] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.connect.model.LexBot = {
    import LexBot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.LexBot
      .builder()
      .optionallyWith(
        name.map(value => BotName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        lexRegion.map(value => LexRegion.unwrap(value): java.lang.String)
      )(_.lexRegion)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.LexBot.ReadOnly =
    zio.aws.connect.model.LexBot.wrap(buildAwsValue())
}
object LexBot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.LexBot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.LexBot = zio.aws.connect.model
      .LexBot(name.map(value => value), lexRegion.map(value => value))
    def name: Option[BotName]
    def lexRegion: Option[LexRegion]
    def getName: ZIO[Any, AwsError, BotName] =
      AwsError.unwrapOptionField("name", name)
    def getLexRegion: ZIO[Any, AwsError, LexRegion] =
      AwsError.unwrapOptionField("lexRegion", lexRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.LexBot
  ) extends zio.aws.connect.model.LexBot.ReadOnly {
    override val name: Option[BotName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.BotName(value))
    override val lexRegion: Option[LexRegion] = scala
      .Option(impl.lexRegion())
      .map(value => zio.aws.connect.model.primitives.LexRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.LexBot
  ): zio.aws.connect.model.LexBot.ReadOnly = new Wrapper(impl)
}
