package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LexBotConfig(
    lexBot: Option[zio.aws.connect.model.LexBot] = None,
    lexV2Bot: Option[zio.aws.connect.model.LexV2Bot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.LexBotConfig = {
    import LexBotConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.LexBotConfig
      .builder()
      .optionallyWith(lexBot.map(value => value.buildAwsValue()))(_.lexBot)
      .optionallyWith(lexV2Bot.map(value => value.buildAwsValue()))(_.lexV2Bot)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.LexBotConfig.ReadOnly =
    zio.aws.connect.model.LexBotConfig.wrap(buildAwsValue())
}
object LexBotConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.LexBotConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.LexBotConfig =
      zio.aws.connect.model.LexBotConfig(
        lexBot.map(value => value.asEditable),
        lexV2Bot.map(value => value.asEditable)
      )
    def lexBot: Option[zio.aws.connect.model.LexBot.ReadOnly]
    def lexV2Bot: Option[zio.aws.connect.model.LexV2Bot.ReadOnly]
    def getLexBot: ZIO[Any, AwsError, zio.aws.connect.model.LexBot.ReadOnly] =
      AwsError.unwrapOptionField("lexBot", lexBot)
    def getLexV2Bot
        : ZIO[Any, AwsError, zio.aws.connect.model.LexV2Bot.ReadOnly] =
      AwsError.unwrapOptionField("lexV2Bot", lexV2Bot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.LexBotConfig
  ) extends zio.aws.connect.model.LexBotConfig.ReadOnly {
    override val lexBot: Option[zio.aws.connect.model.LexBot.ReadOnly] = scala
      .Option(impl.lexBot())
      .map(value => zio.aws.connect.model.LexBot.wrap(value))
    override val lexV2Bot: Option[zio.aws.connect.model.LexV2Bot.ReadOnly] =
      scala
        .Option(impl.lexV2Bot())
        .map(value => zio.aws.connect.model.LexV2Bot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.LexBotConfig
  ): zio.aws.connect.model.LexBotConfig.ReadOnly = new Wrapper(impl)
}
