package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.AliasArn
import scala.jdk.CollectionConverters._
final case class LexV2Bot(aliasArn: Option[AliasArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.LexV2Bot = {
    import LexV2Bot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.LexV2Bot
      .builder()
      .optionallyWith(
        aliasArn.map(value => AliasArn.unwrap(value): java.lang.String)
      )(_.aliasArn)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.LexV2Bot.ReadOnly =
    zio.aws.connect.model.LexV2Bot.wrap(buildAwsValue())
}
object LexV2Bot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.LexV2Bot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.LexV2Bot =
      zio.aws.connect.model.LexV2Bot(aliasArn.map(value => value))
    def aliasArn: Option[AliasArn]
    def getAliasArn: ZIO[Any, AwsError, AliasArn] =
      AwsError.unwrapOptionField("aliasArn", aliasArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.LexV2Bot
  ) extends zio.aws.connect.model.LexV2Bot.ReadOnly {
    override val aliasArn: Option[AliasArn] = scala
      .Option(impl.aliasArn())
      .map(value => zio.aws.connect.model.primitives.AliasArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.LexV2Bot
  ): zio.aws.connect.model.LexV2Bot.ReadOnly = new Wrapper(impl)
}
